/******************************************************************************
* (C) Copyright 2008 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifdef LINUX

#include "b_pci.h"

#include <assert.h>
#include <memory.h>
#include <fcntl.h>

#include "AgtPCIPort.h"
#include "AgtOSPort.h"

#include <stdio.h>
#include <stdlib.h>

#include<sys/ioctl.h>

#include <unistd.h>


void CAgtOSPort::OSDeviceIdGet(UInt16 vendId,UInt16 devId,UInt16 index, UInt32* deviceId)
{
  vendId;devId;
  *deviceId=index;
}

void CAgtOSPort::OSOpenPort(UInt32 deviceId, HANDLE &osHandle,AgtPortHandleT *portHandle)
{
  // Compare function bx_errtype BestXOpenPCI(int portnum, bx_portnumtype * pOsHandle)
  // in file xlxutil.c

  osHandle=AGT_INVALID_OSHANDLE;
  *portHandle=AGT_INVALID_PORTHANDLE;

  int portnum=deviceId; 
  *portHandle=deviceId; // zero based index here into OsHandle array
  
  bestpci_general_info geninf;
  bestpci_device_info devinf;
  int fd,devnr,portnumToOpen;
  char name[1024];
  char path[1024];
  
  // Set default path to be used
  strcpy(path,"/dev");
  sprintf(name,"%s/best/pci0",path);     // Open our generic device

  fd=open(name,O_RDONLY);
  if (fd<0) {
    osHandle=AGT_INVALID_OSHANDLE;
    AGT_THROW("Could not open generic PCIE driver device");
  }
 
  ioctl(fd,0,&geninf);                   // Get the generic driver-infos
 
  // Search through all available devices till the one with right portnum is found
  devnr=1;
  portnumToOpen=0; /* 0 is invalid*/
//  printf("Number of devices found: %d \n",geninf.dev_count);  
  devinf.vendor_id=~AGILENT_VENDOR_ID;
//  printf("Found the following devices:\n");
  while (devnr<=geninf.dev_count) 
  {
    ioctl(fd,devnr,&devinf);
//    printf("devnr=%d: vendor=0x%04lx device=0x%04lx\n",devnr, devinf.vendor_id,devinf.device_id);

    if (devinf.device_id==AGILENT_DEVICE_4305 && devinf.vendor_id==AGILENT_VENDOR_ID && (portnum+1)==devnr)
    {
      portnumToOpen = portnum+1;
    }

    devnr++;
  }
  close(fd);

  // open the desired device
  if (portnumToOpen != 0)
  {  
    // If desired device is found in the system
    sprintf(name,"%s/best/pci%d",path,portnumToOpen);      // Open its device-node
    osHandle=(HANDLE)open(name,O_RDWR);  
    if (osHandle>=0)
    {
      // Fine, done.
      *portHandle=portnumToOpen-1;
      return;
    }
    else
    {
      printf("Failed to open file, errno %d:\n",osHandle);   
    }
  }

  osHandle=AGT_INVALID_OSHANDLE;
  AGT_THROW("Could not open PCIE driver");
}

void CAgtOSPort::OSClosePort(HANDLE myOSHandle)
{
  close(myOSHandle);
}

void CAgtOSPort::OSConfRegDirectRead(HANDLE myOSHandle,UInt32 address,UInt32 &val)
{
  // Executes a direct config access without using
  // the PCI API protocol.

  UInt32 data=address;
  ioctl(myOSHandle, IOCTL_NTIO_GET_CONFIG_DW, &data);
  val=data;
}

void CAgtOSPort::OSConfRegDirectWrite(HANDLE myOSHandle,UInt32 address,UInt32 val)
{
  // Executes a direct config access without using
  // the PCI API protocol.

  b_configdrivertype WriteBuffer;

  WriteBuffer.Offset = address;
  WriteBuffer.Data.Data = val;
  ioctl(myOSHandle,IOCTL_NTIO_SET_CONFIG_DW, &WriteBuffer);
}

#endif
